/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.blockentity.networking.WirelessBlockEntity;
import appeng.core.AEConfig;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.guisync.GuiSync;
import appeng.menu.implementations.MenuTypeBuilder;
import appeng.menu.slot.RestrictedInputSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;

public class WirelessMenu
extends AEBaseMenu {
    public static final MenuType<WirelessMenu> TYPE = MenuTypeBuilder.create(WirelessMenu::new, WirelessBlockEntity.class).requirePermission(SecurityPermissions.BUILD).build("wireless");
    private final RestrictedInputSlot boosterSlot;
    @GuiSync(value=1)
    public long range = 0L;
    @GuiSync(value=2)
    public long drain = 0L;

    public WirelessMenu(int id, Inventory ip, WirelessBlockEntity te) {
        super(TYPE, id, ip, te);
        this.boosterSlot = new RestrictedInputSlot(RestrictedInputSlot.PlacableItemType.RANGE_BOOSTER, te.getInternalInventory(), 0);
        this.addSlot(this.boosterSlot, SlotSemantics.STORAGE);
        this.createPlayerInventorySlots(ip);
    }

    @Override
    public void m_38946_() {
        int boosters = this.boosterSlot.m_7993_().m_41619_() ? 0 : this.boosterSlot.m_7993_().m_41613_();
        this.setRange((long)(10.0 * AEConfig.instance().wireless_getMaxRange(boosters)));
        this.setDrain((long)(100.0 * AEConfig.instance().wireless_getPowerDrain(boosters)));
        super.m_38946_();
    }

    public long getRange() {
        return this.range;
    }

    private void setRange(long range) {
        this.range = range;
    }

    public long getDrain() {
        return this.drain;
    }

    private void setDrain(long drain) {
        this.drain = drain;
    }
}

